from Grammar import Predicate, OfficeJSPredicate, Criterion
from pathlib import Path
from enum import Enum


class ParsingException(Exception):
    pass


def parse(officejs_script: str):
    if "cellValue" in officejs_script:
        if "Between" in officejs_script or "between" in officejs_script:
            return OfficeJSPredicate(Predicate.Between, [])
        elif "EqualTo" in officejs_script or "equalTo" in officejs_script:
            return OfficeJSPredicate(Predicate.EqualTo, [])
        elif "GreaterThan" in officejs_script or "greaterThan" in officejs_script:
            return OfficeJSPredicate(Predicate.GreaterThan, [])
        elif (
            "GreaterThanOrEqual" in officejs_script
            or "greaterThanOrEqual" in officejs_script
        ):
            return OfficeJSPredicate(Predicate.GreaterThanOrEqual, [])
        elif "LessThan" in officejs_script or "lessThan" in officejs_script:
            return OfficeJSPredicate(Predicate.LessThan, [])
        elif (
            "LessThanOrEqual" in officejs_script or "lessThanOrEqual" in officejs_script
        ):
            return OfficeJSPredicate(Predicate.LessThanOrEqual, [])
        elif "NotBetween" in officejs_script or "notBetween" in officejs_script:
            return OfficeJSPredicate(Predicate.NotBetween, [])
        elif "NotEqualTo" in officejs_script or "notEqualTo" in officejs_script:
            return OfficeJSPredicate(Predicate.NotEqualTo, [])
        raise ParsingException(
            f"No Valid Cell Value Operation (LessThan, EqualTo, Between, etc.) found in {officejs_script}"
        )

    if "colorScale" in officejs_script:
        optional = []
        if "lowestValue" in officejs_script or "LowestValue" in officejs_script:
            optional.append(Criterion.LowestValue)
        if "highestValue" in officejs_script or "HighestValue" in officejs_script:
            optional.append(Criterion.HighestValue)
        if "number" in officejs_script or "Number" in officejs_script:
            optional.append(Criterion.Number)
        if "percent" in officejs_script or "Percent" in officejs_script:
            optional.append(Criterion.Percent)
        if "formula" in officejs_script or "Formula" in officejs_script:
            optional.append(Criterion.Formula)
        if "percentile" in officejs_script or "Percentile" in officejs_script:
            optional.append(Criterion.Percentile)
        return OfficeJSPredicate(Predicate.ColorScale, optional)

    if "custom" in officejs_script:
        return OfficeJSPredicate(Predicate.Formula, [])

    if "dataBar" in officejs_script:
        optional = []
        if "LeftToRight" in officejs_script or "leftToRight" in officejs_script:
            optional.append(Criterion.LeftToRight)
        if "RightToLeft" in officejs_script or "rightToLeft" in officejs_script:
            optional.append(Criterion.RightToLeft)
        return OfficeJSPredicate(Predicate.DataBar, [])

    if "iconSet" in officejs_script:
        optional = []
        if "lowestValue" in officejs_script or "LowestValue" in officejs_script:
            optional.append(Criterion.LowestValue)
        if "highestValue" in officejs_script or "HighestValue" in officejs_script:
            optional.append(Criterion.HighestValue)
        if "number" in officejs_script or "Number" in officejs_script:
            optional.append(Criterion.Number)
        if "percent" in officejs_script or "Percent" in officejs_script:
            optional.append(Criterion.Percent)
        if "formula" in officejs_script or "Formula" in officejs_script:
            optional.append(Criterion.Formula)
        if "percentile" in officejs_script or "Percentile" in officejs_script:
            optional.append(Criterion.Percentile)
        if "greaterThan" in officejs_script or "GreaterThan" in officejs_script:
            optional.append(Criterion.GreaterThan)
        if (
            "greaterThanOrEqual" in officejs_script
            or "GreaterThanOrEqual" in officejs_script
        ):
            optional.append(Criterion.GreaterThanOrEqual)
        return OfficeJSPredicate(Predicate.IconSet, optional)

    if "presetCriteria" in officejs_script:
        if "aboveAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.AboveAverage, [])
        elif "belowAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.BelowAverage, [])
        elif "blanks" in officejs_script:
            return OfficeJSPredicate(Predicate.Blanks, [])
        elif "duplicateValues" in officejs_script:
            return OfficeJSPredicate(Predicate.DuplicateValues, [])
        elif "equalOrAboveAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.EqualOrAboveAverage, [])
        elif "equalOrBelowAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.EqualOrBelowAverage, [])
        elif "errors" in officejs_script:
            return OfficeJSPredicate(Predicate.Errors, [])
        elif "lastMonth" in officejs_script:
            return OfficeJSPredicate(Predicate.LastMonth, [])
        elif "lastSevenDays" in officejs_script:
            return OfficeJSPredicate(Predicate.LastSevenDays, [])
        elif "lastWeek" in officejs_script:
            return OfficeJSPredicate(Predicate.LastWeek, [])
        elif "nextMonth" in officejs_script:
            return OfficeJSPredicate(Predicate.NextMonth, [])
        elif "nextWeek" in officejs_script:
            return OfficeJSPredicate(Predicate.NextWeek, [])
        elif "nonBlanks" in officejs_script:
            return OfficeJSPredicate(Predicate.NonBlanks, [])
        elif "nonErrors" in officejs_script:
            return OfficeJSPredicate(Predicate.NonErrors, [])
        elif "oneStdDevAboveAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.OneStdDevAboveAverage, [])
        elif "oneStdDevBelowAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.OneStdDevBelowAverage, [])
        elif "thisMonth" in officejs_script:
            return OfficeJSPredicate(Predicate.ThisMonth, [])
        elif "thisWeek" in officejs_script:
            return OfficeJSPredicate(Predicate.ThisWeek, [])
        elif "threeStdDevAboveAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.ThreeStdDevAboveAverage, [])
        elif "threeStdDevBelowAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.ThreeStdDevBelowAverage, [])
        elif "today" in officejs_script:
            return OfficeJSPredicate(Predicate.Today, [])
        elif "tomorrow" in officejs_script:
            return OfficeJSPredicate(Predicate.Tomorrow, [])
        elif "twoStdDevAboveAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.TwoStdDevAboveAverage, [])
        elif "twoStdDevBelowAverage" in officejs_script:
            return OfficeJSPredicate(Predicate.TwoStdDevBelowAverage, [])
        elif "uniqueValues" in officejs_script:
            return OfficeJSPredicate(Predicate.UniqueValues, [])
        elif "yesterday" in officejs_script:
            return OfficeJSPredicate(Predicate.Yesterday, [])
        raise ParsingException(
            f"No valid preset (Duplicate, Blanks, Errors, etc.) found in the script: {officejs_script}"
        )

    if "containsText" in officejs_script:
        if "contains" in officejs_script or "Contains" in officejs_script:
            return OfficeJSPredicate(Predicate.Contains, [])
        elif "notContains" in officejs_script or "NotContains" in officejs_script:
            return OfficeJSPredicate(Predicate.NotContains, [])
        elif "beginsWith" in officejs_script or "BeginsWith" in officejs_script:
            return OfficeJSPredicate(Predicate.BeginsWith, [])
        elif "endsWith" in officejs_script or "EndsWith" in officejs_script:
            return OfficeJSPredicate(Predicate.EndsWith, [])
        raise ParsingException(
            f"No Valid text contains operator (Contains, Begins With, etc.) found in script: {officejs_script}"
        )

    if "topBottom" in officejs_script:
        optional = []
        if "TopItems" in officejs_script or "topItems" in officejs_script:
            optional.append(Criterion.TopItems)
        if "TopPercent" in officejs_script or "topPercent" in officejs_script:
            optional.append(Criterion.TopPercent)
        if "BottomItems" in officejs_script or "bottomItems" in officejs_script:
            optional.append(Criterion.BottomItems)
        if "BottomPercent" in officejs_script or "bottomPercent" in officejs_script:
            optional.append(Criterion.BottomPercent)
        return OfficeJSPredicate(Predicate.TopBottom, optional)
    if "TopItems" in officejs_script or "topItems" in officejs_script:
        return OfficeJSPredicate(Predicate.TopBottom, [Criterion.TopItems])
    if "TopPercent" in officejs_script or "topPercent" in officejs_script:
        return OfficeJSPredicate(Predicate.TopBottom, [Criterion.TopPercent])
    if "BottomItems" in officejs_script or "bottomItems" in officejs_script:
        return OfficeJSPredicate(Predicate.TopBottom, [Criterion.BottomItems])
    if "BottomPercent" in officejs_script or "bottomPercent" in officejs_script:
        return OfficeJSPredicate(Predicate.TopBottom, [Criterion.BottomPercent])

    raise ParsingException(f"No Valid CF Rule found in script: {officejs_script}")


def test(test_dir: str):
    for file in Path(test_dir).glob("*.js"):
        with open(file, "r") as f:
            test_case = f.read()
        try:
            print(parse(test_case))
        except ParsingException as e:
            print(f"Test Failed for {file}\nError:{e}")
        print(f"Test Passed For {file}")
    print("All Tests Passed!")


if __name__ == "__main__":
    test("tests/")
